/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.data;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import top.theillusivec4.comforts.common.ComfortsRegistry;

public class ComfortsBlockLootTables
extends BlockLoot {
    private final Map<ResourceLocation, LootTable.Builder> lootBuilders = Maps.newHashMap();

    private static LootTable.Builder getLootBuilder(Block block) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)block).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD)))).m_6509_(ExplosionCondition.m_81661_())));
    }

    public void accept(BiConsumer<ResourceLocation, LootTable.Builder> lootBuilder) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        blocks.addAll(ComfortsRegistry.SLEEPING_BAGS.values());
        blocks.addAll(ComfortsRegistry.HAMMOCKS.values());
        blocks.forEach(block -> this.m_124175_((Block)block, ComfortsBlockLootTables::getLootBuilder));
        HashSet set = Sets.newHashSet();
        for (Block block2 : blocks) {
            ResourceLocation resourcelocation = block2.m_60589_();
            if (resourcelocation == BuiltInLootTables.f_78712_ || !set.add(resourcelocation)) continue;
            LootTable.Builder loottable$builder = this.lootBuilders.remove(resourcelocation);
            if (loottable$builder == null) {
                throw new IllegalStateException(String.format("Missing loottable '%s' for '%s'", resourcelocation, ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block2)));
            }
            lootBuilder.accept(resourcelocation, loottable$builder);
        }
        if (!this.lootBuilders.isEmpty()) {
            throw new IllegalStateException("Created block loot tables for non-blocks: " + this.lootBuilders.keySet());
        }
    }
}

